	define SNA_FILENAME "zapil.sna"
	define TRD_FILENAME "zapil.trd"

	device zxspectrum128

	;define _PLAY_MUSIC
	define _PLAY_MUSICBANK
	define _ANIMATION_MAIN_FLOW
	define _INT_FLOW
	;define _SCROLL_UP
	define _SPLASH_BG
	;define int_counter

	page 0
		
	org #6000
page0s	di : ld sp, $-2

	ifdef _PLAY_MUSIC
	ld a, #10 : call setPage
	call PT3PLAY
	endif

	ifdef _PLAY_MUSICBANK
	call initmus
	ld a,#31
	ld (cifra+1),a
	endif
	
	ifdef _SCROLL_UP
	call init_up
	endif
	
	ld a,#5c, i,a, hl,interr, (#5cff),hl : im 2 : ei

	; main flow
	ld a, 7 : out (#fe), a
	module splash_delay


	; wait pattern
1	ld a, 3
	ld hl, CUR_PATTERN
	cp (hl) : jr nz, 1b

	
	endmodule
	ld a, 16 : call setPage

	ld hl,#5800
	ld de,#5801
	ld bc,#300
	ld (hl),l
	ldir
	ld a,#c9
	ld (intFlow),a
	ld (timelineUpdate),a
    ld hl, MAIN_BG
    call laser521
	ld a,#21
	ld (intFlow),a
	ld (timelineUpdate),a
  

	ifdef _ANIMATION_MAIN_FLOW
cikla
	ifdef _PLAY_MUSICBANK
	ifdef int_counter
	ld a,1
	out (#fe),a
	endif
	call opros
	endif
	call ANIMATION1
	ifdef int_counter
	ld a,2
	out (#fe),a
	endif
	halt
	jr cikla
	else
	ifdef _PLAY_MUSICBANK
	call opros
	halt
	jr $-4
	else
	jr $
	endif
	endif
	ifdef _PLAY_MUSICBANK
opros:
	call #028e
	call #031e
	and a
	jr nz,cifra
	xor a
	ld (cifra+1),a
	ret
cifra:	
	ld b,0
	cp b
	ret z
	cp #30
	jr nz,dali
	ld a,(mus_kol+1)
	cp #3b
	jr nz,dali
	ld c,a
	ld a,#30
	ld (cifra+1),a
	ld a,c
	dec a
	jr dali2
dali:
	cp #31
	ret c
mus_kol
	cp #34
	ret nc
	ld (cifra+1),a
dali2:
	sub #31
	add a,a
	add a,a
	ld e,a
	ld d,0
	ld hl,MusicBankTable
	add hl,de
	jr initmus+3
initmus:
	ld hl,MusicBankTable
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)
	ld (mus_page+1),a
	ld bc,#7ffd
	out (c),a
	ex de,hl
	ifdef _PLAY_MUSICBANK
	push hl
	call restore
	pop hl
	endif
	jp PT3PLAY_MB+3
	endif

	;int flow
	ifdef _INT_FLOW
	; Обработчик перываний. Вызывается каждый int
intFlow
	ld hl, INT_DATA
ifMain	ld a, (hl) : inc hl
	cp #ff
	jp z,fixer	; end of flow
	or a : jr z, ifSkip7
	ld a, (hl) : inc hl : call setPage
	ld a, (hl) : inc hl : ld (ifCall + 1), a
	ld a, (hl) : inc hl : ld (ifCall + 2), a
	push hl 
ifCall	call #0000
	pop hl
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip3
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip2
	; закончили эффект
	ld de, #0006 : sbc hl, de
fix3:
	xor a
	ld (hl), a
	add hl, de
	inc hl
	ld a, (hl) : inc hl : cp #ff : jr z, ifMain ; после эффекта ничего
	push hl
fix1:
	call intFlowPush
	pop hl
	jr ifMain
ifSkip7	dup 4 : inc hl : edup
ifSkip3	inc hl	
ifSkip2	inc hl
ifSkip1	inc hl
	jr ifMain

	; Обработчик таймлайна. Вызывается после каждой смены паттерна
timelineUpdate
	; остановить процедуры, если stop_pattern == CUR_PATTERN
fix2:
	ld hl, CUR_PATTERN
	ld ix, INT_DATA
	ld de, #0008
tuStage1c	ld a, (ix + 0) : cp #ff : jr z, tuStage2
	or a : jr z, tuStage1e
	ld a, (ix + 6) : cp (hl) : jr nz, tuStage1e

	; останавливаем
	xor a : ld (ix + 0), a
tuStage1e	add ix, de
	jr tuStage1c

tuStage2	; сжать main cycle (выкинуть остановленные, остальное уплотнить)
	ld hl, INT_DATA + 8
	ld de, INT_DATA
	ld bc, #0008
tuStage2c	ld a, (hl) : cp #ff : jr z, tuStage3
	ld a, (de) : or a : jr nz, tuStage2sk
	ld a, (hl) : or a : jr z, tuStage2sk2
	; переносим
	push bc : ldir : pop bc	
	jr tuStage2c
tuStage2sk	ex de, hl : add hl, bc : ex de, hl 
tuStage2sk2	add hl, bc : jr tuStage2c

tuStage3	; добавить процедуры, если start_pattern == CUR_PATTERN
	ld ix, CUR_PATTERN
	ld hl, TIMELINE
	ld de, #0008
tuStage3c	ld a, (hl) : cp #ff : ret z
	cp (ix + 0) : jr nz, tuStage3e
	push hl, de
	call intFlowPushHL
	pop de, hl
tuStage3e	add hl, de : jr tuStage3c

	; Добавляем процедуру в обработчик перываний
	; a - номер процедуры в TIMELINE
intFlowPush
	ld h, #00 : ld l, a
	dup 3 : add hl, hl : edup
	ld de, TIMELINE
	add hl, de
intFlowPushHL
	ld de, INT_DATA
	ld bc, #0008
ifpCycle	ld a, (de) 
	or a : jr z, ifpDo
	cp #ff : jr z, ifpDo
	dup 8 : inc de : edup
	jr ifpCycle
ifpDo	; заносим
	push hl
	ld a, #01 : ld (hl), a ; маркер `run`
	ldir
	pop hl
	ld a, #fe : ld (hl), a ; защита от повторного добавления
	ret

INT_DATA	block 16*08, #ff
TIMELINE
	db #03		; start pattern
	db #10		; proc page
	dw SCROLL_FUNC		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW1		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW2		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #03		; next run

	db #fe		; start pattern
	db #10		; proc page
	dw INTFLOW3		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW4		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #05		; next run

	db #fe		; start pattern
	db #10		; proc page
	dw INTFLOW5		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run

	db #03		; start pattern
	db #10		; proc page
	dw INTFLOW6		; proc address
	dw #0004		; ints counter
	db #ff		; stop pattern
	db #07		; next run

	db #fe		; start pattern
	db #10		; proc page
	dw INTFLOW7		; proc address
	dw #ffff		; ints counter
	db #ff		; stop pattern
	db #ff		; next run


	db #ff		; end of TIMELINE

INTFLOW1
	module main_analyzer

	ld hl,#4860
	ld a,8
	call getreg
	ld hl,#4880
	ld a,9
	call getreg
	ld hl,#48a0
	ld a,10
getreg:
	ld bc,$FFFD
	out (c),a
	in a,(c)
	and 15
	push hl
	ld h,0
	ld l,a
	ld de,equbar
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,de
	push hl
	pop ix
	pop hl
 dup 8
 call drawchar
edup 
	ret
drawchar:
	ld e,(ix+0)
	inc ix
	ld d,h
	dup 7
	ld (hl),e
	inc h
edup
	ld (hl),0
	ld h,d
	inc l
	ret
equbar:
 db %00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 0
 db %11100000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 1
 db %11101110,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 2
 db %11101110,%11100000,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 3
 db %11101110,%11101110,%00000000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 4
 db %11101110,%11101110,%11100000,%00000000,%00000000,%00000000,%00000000,%00000000 ; 5
 db %11101110,%11101110,%11101110,%00000000,%00000000,%00000000,%00000000,%00000000 ; 6
 db %11101110,%11101110,%11101110,%11100000,%00000000,%00000000,%00000000,%00000000 ; 7
 db %11101110,%11101110,%11101110,%11101110,%00000000,%00000000,%00000000,%00000000 ; 8
 db %11101110,%11101110,%11101110,%11101110,%11100000,%00000000,%00000000,%00000000 ; 9
 db %11101110,%11101110,%11101110,%11101110,%11101110,%00000000,%00000000,%00000000 ; 10
 db %11101110,%11101110,%11101110,%11101110,%11101110,%11100000,%00000000,%00000000 ; 11
 db %11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%00000000,%00000000 ; 12
 db %11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%11100000,%00000000 ; 13
 db %11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%00000000 ; 14
 db %11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%11101110,%11100000 ; 15

	
	endmodule
INTFLOW2
	ret

INTFLOW3
ANIMATION4
	module animation4


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4			; revert to start of animation
1	ld a, (hl) : ld (anima + 1), a
	inc hl : ld a, (hl) : call setPage
	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl
	jp (hl)
anima_proc
	db 3, 1 : dw A4_1_0000
	db 3, 1 : dw A4_1_0001
	db 3, 1 : dw A4_1_0002
	db 3, 1 : dw A4_1_0003
	db 3, 1 : dw A4_1_0004
	db 3, 1 : dw A4_1_0005
	db 3, 3 : dw A4_3_0006
	db 3, 3 : dw A4_3_0007
	db 3, 3 : dw A4_3_0008
	db 3, 3 : dw A4_3_0009
	db 3, 3 : dw A4_3_000a
	db 3, 3 : dw A4_3_000b
	db 3, 3 : dw A4_3_000c
	db 3, 3 : dw A4_3_000d
	db 3, 3 : dw A4_3_000e
	db 3, 3 : dw A4_3_000f
	db 3, 4 : dw A4_4_0010
	db 3, 4 : dw A4_4_0011
	db 3, 4 : dw A4_4_0012
	db 3, 4 : dw A4_4_0013
	db 3, 4 : dw A4_4_0014
	db 3, 4 : dw A4_4_0015
	db 3, 4 : dw A4_4_0016
	db 3, 4 : dw A4_4_0017
	db 3, 4 : dw A4_4_0018 
	db #00
	
	
	endmodule
INTFLOW4
	ret

INTFLOW5
ANIMATION3
	module animation3


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4			; revert to start of animation
1	ld a, (hl) : ld (anima + 1), a
	inc hl : ld a, (hl) : call setPage
	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl
	jp (hl)
anima_proc
	db 3, 4 : dw A3_4_0000
	db 3, 1 : dw A3_1_0001
	db 3, 1 : dw A3_1_0002
	db 3, 3 : dw A3_3_0003
	db 3, 3 : dw A3_3_0004
	db 3, 4 : dw A3_4_0005
	db 3, 4 : dw A3_4_0006
	db 3, 4 : dw A3_4_0007
	db 3, 4 : dw A3_4_0008
	db 3, 4 : dw A3_4_0009
	db 3, 4 : dw A3_4_000a
	db 3, 6 : dw A3_6_000b
	db 3, 6 : dw A3_6_000c
	db 3, 6 : dw A3_6_000d
	db 3, 6 : dw A3_6_000e
	db 3, 6 : dw A3_6_000f
	db 3, 6 : dw A3_6_0010
	db 3, 6 : dw A3_6_0011
	db 3, 6 : dw A3_6_0012
	db 3, 6 : dw A3_6_0013
	db 3, 6 : dw A3_6_0014
	db 3, 6 : dw A3_6_0015
	db 3, 6 : dw A3_6_0016
	db 3, 6 : dw A3_6_0017
	db 3, 6 : dw A3_6_0018
	db 3, 6 : dw A3_6_0019
	db 3, 6 : dw A3_6_001a
	db 3, 6 : dw A3_6_001b
	db 3, 6 : dw A3_6_001c
	db 3, 6 : dw A3_6_001d
	db 3, 6 : dw A3_6_001e
	db 3, 6 : dw A3_6_001f
	db 3, 6 : dw A3_6_0020
	db 3, 6 : dw A3_6_0021
	db 3, 6 : dw A3_6_0022
	db 3, 6 : dw A3_6_0023
	db 3, 6 : dw A3_6_0024
	db 3, 6 : dw A3_6_0025
	db 3, 6 : dw A3_6_0026
	db 3, 6 : dw A3_6_0027
	db 3, 6 : dw A3_6_0028
	db 3, 6 : dw A3_6_0029
	db 3, 6 : dw A3_6_002a
	db 3, 6 : dw A3_6_002b
	db 3, 6 : dw A3_6_002c
	db 3, 6 : dw A3_6_002d
	db 3, 6 : dw A3_6_002e
	db 10, 6 : dw A3_6_002f
	db 3, 6 : dw A3_6_0030
	db 3, 6 : dw A3_6_0031
	db 3, 6 : dw A3_6_0032
	db 3, 6 : dw A3_6_0033
	db 3, 6 : dw A3_6_0034
	db 3, 6 : dw A3_6_0035
	db 3, 6 : dw A3_6_0036
	db 3, 6 : dw A3_6_0037
	db 3, 7 : dw A3_7_0038
	db 3, 7 : dw A3_7_0039
	db 3, 6 : dw A3_6_003a
	db 3, 7 : dw A3_7_003b
	db 3, 7 : dw A3_7_003c
	db 3, 7 : dw A3_7_003d
	db 3, 7 : dw A3_7_003e
	db 3, 7 : dw A3_7_003f
	db 3, 7 : dw A3_7_0040
	db 3, 7 : dw A3_7_0041
	db 3, 7 : dw A3_7_0042
	db 3, 7 : dw A3_7_0043
	db 3, 7 : dw A3_7_0044
	db 3, 7 : dw A3_7_0045
	db 3, 7 : dw A3_7_0046
	db 3, 7 : dw A3_7_0047
	db 3, 7 : dw A3_7_0048
	db 3, 7 : dw A3_7_0049
	db 3, 7 : dw A3_7_004a
	db 3, 7 : dw A3_7_004b
	db 3, 7 : dw A3_7_004c
	db 3, 7 : dw A3_7_004d
	db 3, 7 : dw A3_7_004e
	db 3, 7 : dw A3_7_004f
	db 3, 7 : dw A3_7_0050
	db 3, 7 : dw A3_7_0051
	db 3, 7 : dw A3_7_0052
	db 3, 7 : dw A3_7_0053
	db 3, 7 : dw A3_7_0054
	db 3, 7 : dw A3_7_0055
	db 3, 7 : dw A3_7_0056
	db 3, 7 : dw A3_7_0057
	db 3, 7 : dw A3_7_0058
	db 3, 7 : dw A3_7_0059
	db 3, 7 : dw A3_7_005a
	db 3, 7 : dw A3_7_005b
	db 3, 7 : dw A3_7_005c
	db 3, 7 : dw A3_7_005d
	db 3, 7 : dw A3_7_005e
	db 15, 7 : dw A3_7_005f
	db 3, 7 : dw A3_7_0060 
	db #00
	
	
	endmodule
INTFLOW6
	ret

INTFLOW7
ANIMATION2
	module animation2


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4
1	ld a, (hl) : ld (anima + 1), a
	
	; set page
	inc hl : ld a, (hl) : call setPage

	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl

	; determine data flow start
	push hl
1	ld a, (hl) : inc hl : cp %11111111
	jr nz, 1b
	pop ix

	; set start address
	ld a, (hl) : ld e, a : inc hl
	ld a, (hl) : ld d, a : inc hl
_an_cycle	ld a, (ix + 0) : inc ix
	bit 7, a : jr z, 1f
	ld c, a
	and #e0
	cp #a0 : jr z, _anc_jmp100
	ret 
	; end of frame		
1	bit 6, a : jr z, _anc_set
_anc_jmp	; jump screen address
	and #3f
	inc a : ld c, a : ld b, 0
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_jmp100	ld a, c
	and #0f
	or a : jr z, 1f
	inc d : dec a : jr nz, $-2
1	ld a, c : and %00010000 : jr z, _an_cycle
	ld bc, #0080	; additional jump +128 bytes
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_set	; copy N bytes from flow to screen
	inc a
	ldi : dec a : jr nz, $-3
	jr _an_cycle
anima_proc
	db 250, 6 : dw A2_6_0000
	db 250, 4 : dw A2_4_0001
	db 250, 4 : dw A2_4_0002
	db 250, 1 : dw A2_1_0003
	db 250, 1 : dw A2_1_0004
	db 250, 7 : dw A2_7_0005
	db 250, 7 : dw A2_7_0006
	db 250, 1 : dw A2_1_0007
	db 250, 7 : dw A2_7_0008
	db 250, 7 : dw A2_7_0009
	db 250, 7 : dw A2_7_000a
	db 250, 3 : dw A2_3_000b
	db 250, 3 : dw A2_3_000c
	db 250, 3 : dw A2_3_000d
	db 250, 3 : dw A2_3_000e
	db 250, 3 : dw A2_3_000f
	db 250, 3 : dw A2_3_0010
	db 250, 0 : dw A2_0_0011
	db 250, 0 : dw A2_0_0012
	db 250, 0 : dw A2_0_0013
	db 250, 0 : dw A2_0_0014
	db 250, 0 : dw A2_0_0015
	db 250, 0 : dw A2_0_0016
	db 250, 0 : dw A2_0_0017
	db 250, 0 : dw A2_0_0018
	db 250, 0 : dw A2_0_0019
	db 250, 0 : dw A2_0_001a
	db 250, 0 : dw A2_0_001b
	db 250, 0 : dw A2_0_001c
	db 250, 0 : dw A2_0_001d
	db 250, 0 : dw A2_0_001e 
	db #00
	
	
	endmodule
	
	endif


CUR_PAGE	db #00
setPage
	or #10
	ld (CUR_PAGE), a : ld bc,#7ffd : out(c), a : ret

    ; Music and pattern handling
    ifdef _PLAY_MUSIC
CUR_PATTERN	db #ff
_curPattern	db #ff	
	align #100
PT3PLAY	include "sources/PTxPlay.asm"
	incbin "res/music"
	else
	; If only MusicBank is enabled, keep non-zero placeholder pattern
	ifdef _PLAY_MUSICBANK
CUR_PATTERN	db #ff
_curPattern	db #ff	
	else
	; No music at all: always 0 pattern
CUR_PATTERN	db #00
_curPattern	db #00
	endif
	endif

	; MusicBank player
	ifdef _PLAY_MUSICBANK
	align #100
PT3PLAY_MB	include "sources/PTxPlay.asm"
	endif

interr	di
	ld (stack+1),sp
	ld sp,#5fd0
	push af,bc,de,hl,ix,iy
	exx : ex af, af'
	push af,bc,de,hl,ix,iy
	
    ; save current page
	ifdef int_counter
	ld a,1
	out (#fe),a
	endif
	ld a, (CUR_PAGE)
	ld (_CP_REST + 1), a

	ifdef _INT_FLOW
	call intFlow
	endif

    ; Music tick and pattern update
    ifdef _PLAY_MUSICBANK
mus_page:
	ld a,#10
    ld bc,#7ffd
    out (c),a
	
	ifdef _PLAY_MUSICBANK
	call proverka
	endif
    
	call PT3PLAY_MB + 5
    ld a,#10
    ld bc,#7ffd
    out (c),a
	ld a, (PT3PLAY_MB  + 10)
	rla
	jr nc,play
	ld a,(mus_kol+1)
	ld   b,a
	ld   a,(cifra+1)
	cp   #30
	jr   nz,kotka
	add  a,#0A
kotka:
	inc  a
	cp   b
	jr   c,zapka
	ld   a,#31
zapka:
	ld   (cifra+1),a
	call dali2
    ; update timeline pattern from MusicBank player
play:
    ld a, (PT3PLAY_MB + 11)
    ld hl, _curPattern 
    cp (hl) : jr z, 1f
    ld (hl), a
    ld hl, CUR_PATTERN : inc (HL)
1 
    else
    ifdef _PLAY_MUSIC
    call PT3PLAY + 5
    ld a, (PT3PLAY + 11)
    ld hl, _curPattern 
    cp (hl) : jr z, 1f
    ld (hl), a
    ld hl, CUR_PATTERN : inc (HL)
1	
    endif
    endif

	ifdef _INT_FLOW
	call timelineUpdate
	endif

	; restore page
_CP_REST	ld a, #00 : call setPage
	ifdef int_counter
	ld a,2
	out (#fe),a
	endif
	pop iy,ix,hl,de,bc,af
	exx : ex af, af'
	pop iy,ix,hl,de,bc,af
stack:
	ld sp,0
	ei
	ret
	
	ifdef _INT_FLOW
fixer:
	ld a,(INT_DATA)
	cp #ff
	ret z
timer:
	ld a,0
	inc a
	ld (timer+1),a
	cp #ff
	ret nz
	ld a,#c9
	ld (fix2),a
	ld (timer-1),a
	xor a
	ld hl,0
	ld (fix1),a
	ld (fix1+1),hl
	ld (fix3),hl
	ret
	endif
	
	ifdef _PLAY_MUSICBANK
proverka:
	ld hl,(CrPsPtr)
	inc hl
	inc hl
	ld a,(hl)
	cp #ff
	ret nz
	
zatuh:
    ld   de,AYREGS+8
    ld   hl,zat+1
    ld   (hl),e
    inc  hl
    ld   (hl),d
    ld   hl,podmena
    ld   de,zamena
    ld   (hl),#CD
    inc  hl
    ld   (hl),e
    inc  hl
    ld   (hl),d
    ld   hl,pauza+1
    ld   (hl),#00
    inc  hl
    ld   (hl),#14
    ret
	
zamena:
    push hl
    ld   hl,pauza+2
pauza:
    ld   bc,#0000
    djnz zath1
    ld   b,#14
    inc  c
zath1:
    ld   (hl),b
    dec  hl
    ld   (hl),c
    ld   a,#10
    cp   c
    jr   nc,zath2
    ld   (hl),a
    ld   c,a
zath2:
    ld   b,#03
zat:
    ld   hl,0000
zath4:
    ld   a,(hl)
    and  #0F
    sub  c
    jr   nc,zath3
    xor  a
zath3:
    ld   (hl),a
    inc  hl
    djnz zath4
    xor  a
    ld   de,#FFBF
    pop  hl
    ret
restore:
    ld   hl,podmena
    ld   (hl),#11
    inc  hl
    ld   (hl),#BF
    inc  hl
    ld   (hl),#FF
    ret
	endif
	
	include "sources/laser521.asm"
MusicBankTable:
    dw MB_ADDR_0 : dw 16
    dw MB_ADDR_1 : dw 16
    dw MB_ADDR_2 : dw 16

ANIMATION1
	module animation1


anima	ld a, #01 : dec a : ld (anima + 1), a : ret nz	; animation pause
anima_p	ld hl, anima_proc
	ld a, (hl) : or a : jr nz, 1f
	ld hl, anima_proc + 4
1	ld a, (hl) : ld (anima + 1), a
	
	; set page
	inc hl : ld a, (hl) : call setPage

	inc hl : ld e, (hl)
	inc hl : ld d, (hl)
	inc hl : ld (anima_p + 1), hl
	ex de, hl

	; determine data flow start
	push hl
1	ld a, (hl) : inc hl : cp %11111111
	jr nz, 1b
	pop ix

	; set start address
	ld a, (hl) : ld e, a : inc hl
	ld a, (hl) : ld d, a : inc hl
_an_cycle	ld a, (ix + 0) : inc ix
	bit 7, a : jr z, 1f
	ld c, a
	and #e0
	cp #a0 : jr z, _anc_jmp100
	ret 
	; end of frame		
1	bit 6, a : jr z, _anc_set
_anc_jmp	; jump screen address
	and #3f
	inc a : ld c, a : ld b, 0
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_jmp100	ld a, c
	and #0f
	or a : jr z, 1f
	inc d : dec a : jr nz, $-2
1	ld a, c : and %00010000 : jr z, _an_cycle
	ld bc, #0080	; additional jump +128 bytes
	ex de, hl : add hl, bc : ex de, hl
	jr _an_cycle
_anc_set	; copy N bytes from flow to screen
	inc a
	ldi : dec a : jr nz, $-3
	jr _an_cycle
anima_proc
	db 255, 7 : dw A1_7_0000
	db 255, 7 : dw A1_7_0001
	db 255, 0 : dw A1_0_0002
	db 255, 0 : dw A1_0_0003
	db 255, 0 : dw A1_0_0004
	db 255, 0 : dw A1_0_0005
	db 255, 0 : dw A1_0_0006
	db 255, 0 : dw A1_0_0007
	db 255, 0 : dw A1_0_0008
	db 255, 0 : dw A1_0_0009
	db 255, 0 : dw A1_0_000a 
	db #00
	
	
	endmodule
MAIN_BG	incbin "res/main_bg.pck"
A1_0_0002	include "res/A1_0_0002.asm"
A1_0_0003	include "res/A1_0_0003.asm"
A1_0_0004	include "res/A1_0_0004.asm"
A1_0_0005	include "res/A1_0_0005.asm"
A1_0_0006	include "res/A1_0_0006.asm"
A1_0_0007	include "res/A1_0_0007.asm"
A1_0_0008	include "res/A1_0_0008.asm"
A1_0_0009	include "res/A1_0_0009.asm"
A1_0_000a	include "res/A1_0_000a.asm"
A2_0_0011	include "res/A2_0_0011.asm"
A2_0_0012	include "res/A2_0_0012.asm"
A2_0_0013	include "res/A2_0_0013.asm"
A2_0_0014	include "res/A2_0_0014.asm"
A2_0_0015	include "res/A2_0_0015.asm"
A2_0_0016	include "res/A2_0_0016.asm"
A2_0_0017	include "res/A2_0_0017.asm"
A2_0_0018	include "res/A2_0_0018.asm"
A2_0_0019	include "res/A2_0_0019.asm"
A2_0_001a	include "res/A2_0_001a.asm"
A2_0_001b	include "res/A2_0_001b.asm"
A2_0_001c	include "res/A2_0_001c.asm"
A2_0_001d	include "res/A2_0_001d.asm"
A2_0_001e	include "res/A2_0_001e.asm"
SCROLL_FUNC
	
	
S8CNTP	ld a, #07 : inc a : and #07 : ld (S8CNTP + 1), a
	or a : jr nz, p1scroll
S8CNT	ld hl, SCROLL_TEXT - 1 
	inc hl : ld (S8CNT + 1), hl
	ld a, (hl) : or a : jp nz, 1f
		
	; restart scroll
	ld hl, SCROLL_TEXT 
	ld (S8CNT + 1), hl
	ld a, (hl)

1	call drw_sym8x8
		
p1scroll
	ld de, #507d		; scroll screen address
	ld hl, SCROLL_BUFF
	ld a, #08 : ld (p1sA + 1), a

p1s1	scf : ccf ; reset carry
	
	rl (hl) : inc l
	ex de, hl
	push hl
	DUP 18
	rl (hl) : dec l
	EDUP
	pop hl
	call downHL
	ex de, hl
p1sA	ld a, #00 : dec a : ld (p1sA + 1), a : ret z : jp p1s1

drw_sym8x8	
	sub #20 : cp #60 : jr C, $+4 : sub #60	; fix chr for cutted font
		
	ld H, #00 : ld L, A
	DUP 3
	add hl, hl ; HL = HL*8
	EDUP
		
	ld bc, FONT8X8
	add hl, bc	; Адрес спрайта
	ld (_ds8SP + 1), SP
	ld sp, hl 
	
	ld hl, SCROLL_BUFF 
	DUP 4
	pop bc : ld (hl), c : inc hl : ld (hl), b : inc hl
	EDUP
_ds8SP	ld SP, #0000	
	ret
downHL	inc h : ld a,h : and #07 : ret nz : ld a,l : sub #e0 : ld l,a : sbc a,a : and #f8 : add a,h : ld h,a : ret
	
SCROLL_BUFF	block 8
SCROLL_TEXT	incbin "res/scroll"
	db #00
FONT8X8	incbin "res/8x8font"
MB_ADDR_0:
    incbin "res/music1.pt3"
MB_ADDR_1:
    incbin "res/music2.pt3"
MB_ADDR_2:
    incbin "res/music3.pt3"
page0e	display /d, 'Page 0 free: ', #ffff - $
	define _page1 : page 1 : org #c000
page1s
A4_1_0000	include "res/A4_1_0000.asm"
A4_1_0001	include "res/A4_1_0001.asm"
A4_1_0002	include "res/A4_1_0002.asm"
A4_1_0003	include "res/A4_1_0003.asm"
A4_1_0004	include "res/A4_1_0004.asm"
A4_1_0005	include "res/A4_1_0005.asm"
A3_1_0001	include "res/A3_1_0001.asm"
A3_1_0002	include "res/A3_1_0002.asm"
A2_1_0003	include "res/A2_1_0003.asm"
A2_1_0004	include "res/A2_1_0004.asm"
A2_1_0007	include "res/A2_1_0007.asm"
page1e	display /d, 'Page 1 free: ', #ffff - $
	define _page3 : page 3 : org #c000
page3s
A4_3_0006	include "res/A4_3_0006.asm"
A4_3_0007	include "res/A4_3_0007.asm"
A4_3_0008	include "res/A4_3_0008.asm"
A4_3_0009	include "res/A4_3_0009.asm"
A4_3_000a	include "res/A4_3_000a.asm"
A4_3_000b	include "res/A4_3_000b.asm"
A4_3_000c	include "res/A4_3_000c.asm"
A4_3_000d	include "res/A4_3_000d.asm"
A4_3_000e	include "res/A4_3_000e.asm"
A4_3_000f	include "res/A4_3_000f.asm"
A3_3_0003	include "res/A3_3_0003.asm"
A3_3_0004	include "res/A3_3_0004.asm"
A2_3_000b	include "res/A2_3_000b.asm"
A2_3_000c	include "res/A2_3_000c.asm"
A2_3_000d	include "res/A2_3_000d.asm"
A2_3_000e	include "res/A2_3_000e.asm"
A2_3_000f	include "res/A2_3_000f.asm"
A2_3_0010	include "res/A2_3_0010.asm"
page3e	display /d, 'Page 3 free: ', #ffff - $
	define _page4 : page 4 : org #c000
page4s
A4_4_0010	include "res/A4_4_0010.asm"
A4_4_0011	include "res/A4_4_0011.asm"
A4_4_0012	include "res/A4_4_0012.asm"
A4_4_0013	include "res/A4_4_0013.asm"
A4_4_0014	include "res/A4_4_0014.asm"
A4_4_0015	include "res/A4_4_0015.asm"
A4_4_0016	include "res/A4_4_0016.asm"
A4_4_0017	include "res/A4_4_0017.asm"
A4_4_0018	include "res/A4_4_0018.asm"
A3_4_0000	include "res/A3_4_0000.asm"
A3_4_0005	include "res/A3_4_0005.asm"
A3_4_0006	include "res/A3_4_0006.asm"
A3_4_0007	include "res/A3_4_0007.asm"
A3_4_0008	include "res/A3_4_0008.asm"
A3_4_0009	include "res/A3_4_0009.asm"
A3_4_000a	include "res/A3_4_000a.asm"
A2_4_0001	include "res/A2_4_0001.asm"
A2_4_0002	include "res/A2_4_0002.asm"
page4e	display /d, 'Page 4 free: ', #ffff - $
	define _page6 : page 6 : org #c000
page6s
A3_6_000b	include "res/A3_6_000b.asm"
A3_6_000c	include "res/A3_6_000c.asm"
A3_6_000d	include "res/A3_6_000d.asm"
A3_6_000e	include "res/A3_6_000e.asm"
A3_6_000f	include "res/A3_6_000f.asm"
A3_6_0010	include "res/A3_6_0010.asm"
A3_6_0011	include "res/A3_6_0011.asm"
A3_6_0012	include "res/A3_6_0012.asm"
A3_6_0013	include "res/A3_6_0013.asm"
A3_6_0014	include "res/A3_6_0014.asm"
A3_6_0015	include "res/A3_6_0015.asm"
A3_6_0016	include "res/A3_6_0016.asm"
A3_6_0017	include "res/A3_6_0017.asm"
A3_6_0018	include "res/A3_6_0018.asm"
A3_6_0019	include "res/A3_6_0019.asm"
A3_6_001a	include "res/A3_6_001a.asm"
A3_6_001b	include "res/A3_6_001b.asm"
A3_6_001c	include "res/A3_6_001c.asm"
A3_6_001d	include "res/A3_6_001d.asm"
A3_6_001e	include "res/A3_6_001e.asm"
A3_6_001f	include "res/A3_6_001f.asm"
A3_6_0020	include "res/A3_6_0020.asm"
A3_6_0021	include "res/A3_6_0021.asm"
A3_6_0022	include "res/A3_6_0022.asm"
A3_6_0023	include "res/A3_6_0023.asm"
A3_6_0024	include "res/A3_6_0024.asm"
A3_6_0025	include "res/A3_6_0025.asm"
A3_6_0026	include "res/A3_6_0026.asm"
A3_6_0027	include "res/A3_6_0027.asm"
A3_6_0028	include "res/A3_6_0028.asm"
A3_6_0029	include "res/A3_6_0029.asm"
A3_6_002a	include "res/A3_6_002a.asm"
A3_6_002b	include "res/A3_6_002b.asm"
A3_6_002c	include "res/A3_6_002c.asm"
A3_6_002d	include "res/A3_6_002d.asm"
A3_6_002e	include "res/A3_6_002e.asm"
A3_6_002f	include "res/A3_6_002f.asm"
A3_6_0030	include "res/A3_6_0030.asm"
A3_6_0031	include "res/A3_6_0031.asm"
A3_6_0032	include "res/A3_6_0032.asm"
A3_6_0033	include "res/A3_6_0033.asm"
A3_6_0034	include "res/A3_6_0034.asm"
A3_6_0035	include "res/A3_6_0035.asm"
A3_6_0036	include "res/A3_6_0036.asm"
A3_6_0037	include "res/A3_6_0037.asm"
A3_6_003a	include "res/A3_6_003a.asm"
A2_6_0000	include "res/A2_6_0000.asm"
page6e	display /d, 'Page 6 free: ', #ffff - $
	define _page7 : page 7 : org #c000
page7s
A3_7_0038	include "res/A3_7_0038.asm"
A3_7_0039	include "res/A3_7_0039.asm"
A3_7_003b	include "res/A3_7_003b.asm"
A3_7_003c	include "res/A3_7_003c.asm"
A3_7_003d	include "res/A3_7_003d.asm"
A3_7_003e	include "res/A3_7_003e.asm"
A3_7_003f	include "res/A3_7_003f.asm"
A3_7_0040	include "res/A3_7_0040.asm"
A3_7_0041	include "res/A3_7_0041.asm"
A3_7_0042	include "res/A3_7_0042.asm"
A3_7_0043	include "res/A3_7_0043.asm"
A3_7_0044	include "res/A3_7_0044.asm"
A3_7_0045	include "res/A3_7_0045.asm"
A3_7_0046	include "res/A3_7_0046.asm"
A3_7_0047	include "res/A3_7_0047.asm"
A3_7_0048	include "res/A3_7_0048.asm"
A3_7_0049	include "res/A3_7_0049.asm"
A3_7_004a	include "res/A3_7_004a.asm"
A3_7_004b	include "res/A3_7_004b.asm"
A3_7_004c	include "res/A3_7_004c.asm"
A3_7_004d	include "res/A3_7_004d.asm"
A3_7_004e	include "res/A3_7_004e.asm"
A3_7_004f	include "res/A3_7_004f.asm"
A3_7_0050	include "res/A3_7_0050.asm"
A3_7_0051	include "res/A3_7_0051.asm"
A3_7_0052	include "res/A3_7_0052.asm"
A3_7_0053	include "res/A3_7_0053.asm"
A3_7_0054	include "res/A3_7_0054.asm"
A3_7_0055	include "res/A3_7_0055.asm"
A3_7_0056	include "res/A3_7_0056.asm"
A3_7_0057	include "res/A3_7_0057.asm"
A3_7_0058	include "res/A3_7_0058.asm"
A3_7_0059	include "res/A3_7_0059.asm"
A3_7_005a	include "res/A3_7_005a.asm"
A3_7_005b	include "res/A3_7_005b.asm"
A3_7_005c	include "res/A3_7_005c.asm"
A3_7_005d	include "res/A3_7_005d.asm"
A3_7_005e	include "res/A3_7_005e.asm"
A3_7_005f	include "res/A3_7_005f.asm"
A3_7_0060	include "res/A3_7_0060.asm"
A1_7_0000	include "res/A1_7_0000.asm"
A1_7_0001	include "res/A1_7_0001.asm"
A2_7_0005	include "res/A2_7_0005.asm"
A2_7_0006	include "res/A2_7_0006.asm"
A2_7_0008	include "res/A2_7_0008.asm"
A2_7_0009	include "res/A2_7_0009.asm"
A2_7_000a	include "res/A2_7_000a.asm"
page7e	display /d, 'Page 7 free: ', #ffff - $

; --- SlideShow integration ---
; SlideShowTable: dw offset, db bank ... dw $FFFF
; Используйте эту таблицу в своем Z80-коде для показа слайдов.

	include "sources/builder.asm"