<?php

const CACHE_DIR = PROJECT_ROOT . 'var/cache/';

// Function to extract page sizes from compiler log (take first occurrence per page = first compilation)
function extractPageSizesFromLog($log) {
    $pagesFreeHtml = '';
    $totalFreeBytesFromCompiler = null;
    
    if (!empty($log) && preg_match_all('/Page\s*(\d+)\s*free:\s*([0-9]+)/i', $log, $m, PREG_SET_ORDER)) {
        $pageToFree = array();
        foreach ($m as $mm) {
            $pageNum = (int)$mm[1];
            $val = (int)$mm[2];
            if (!array_key_exists($pageNum, $pageToFree)) {
                $pageToFree[$pageNum] = $val; // take first occurrence only
            }
        }
        if (!empty($pageToFree)) {
            ksort($pageToFree);
            $lines = array();
            $sum = 0;
            foreach ($pageToFree as $page => $free) {
                $sum += $free;
                $lines[] = 'page ' . $page . ': ' . number_format($free, 0, '.', ' ') . ' байт';
            }
            $totalFreeBytesFromCompiler = $sum;
            $pagesFreeHtml = '<br/><span style="font-size:12px;color:#888">' . implode('<br/>', $lines) . '</span>';
        }
    }
    
    return array('html' => $pagesFreeHtml, 'total' => $totalFreeBytesFromCompiler);
}

if (!file_exists(CACHE_DIR)) {
    mkdir(CACHE_DIR, 0777, true);
}

if (isset($_GET['get_file'])) {
    $filename = str_replace(array('\\', '/'), array('', ''), $_GET['get_file']);
    if (!file_exists(CACHE_DIR . $filename) || is_dir(CACHE_DIR . $filename)) {
        NFW::i()->stop('File not found');
        return false;
    }

    header('Content-type: application/force-download');
    header('Content-Disposition: attachment; filename="zapil.zip"');
    header("Content-Transfer-Encoding: binary");
    header("Content-Length: " . filesize(CACHE_DIR . $filename));
    readfile(CACHE_DIR . $filename);
    exit;
} elseif (empty($_POST)) {
    // Main page
    NFW::i()->assign('page', array(
        'path' => 'zapilyator',
        'title' => 'Zapilyator',
        'content' => NFW::i()->fetch(PROJECT_ROOT . 'include/templates/zapilyator.tpl')
    ));
    NFW::i()->display('main.tpl');
}

// -----------------
//  Ok. Lets do it!
// -----------------

ini_set('max_execution_time', 300);

require_once PROJECT_ROOT . 'include/helpers/parse256x192.php';
require_once PROJECT_ROOT . 'include/helpers/ZXAnimation.php';

$Zapilyator = new zapilyator(array(
    'cacheDir' => CACHE_DIR,
));

// SlideShow: загрузка архива и парсинг
if (isset($_FILES['slideshow_zip'])) {
    $result = $Zapilyator->upload('slideshow_zip');
    if ($result !== false) {
        $slideShowData = $Zapilyator->parseSlideShow($result['targetFile']);
        if ($slideShowData !== false) {
            // Сохраняем SlideShow-данные в проект
            $data['slideshow'] = $slideShowData;
            // Сохраняем проект
            $projectName = md5(NFW::i()->serializeArray($data));
            $Zapilyator->saveProject($projectName, $data);
            NFW::i()->renderJSON(array(
                'result' => 'success',
                'stage' => 'slideshow_parsed',
                'project_name' => $projectName,
                'trd_merge_enabled' => isset($_POST['trd_merge_enabled']) ? $_POST['trd_merge_enabled'] : '0',
                'int_counter_enabled' => isset($_POST['int_counter_enabled']) ? $_POST['int_counter_enabled'] : '0',
                'log' => array('SlideShow parsed and saved!')
            ));
            exit();
        } else {
            NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
            exit();
        }
    } else {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
        exit();
    }
}

// MusicBank: загрузка архива и парсинг
if (isset($_FILES['musicbank_zip'])) {
    $result = $Zapilyator->upload('musicbank_zip');
    if ($result !== false) {
        $musicBankData = $Zapilyator->parseMusicBank($result['targetFile']);
        if ($musicBankData !== false) {
            // Обрабатываем все данные из формы, как в первой стадии
            $main_color = intval($_POST['main_ink'] + $_POST['main_paper'] * 8 + $_POST['main_bright'] * 64);
            $data = array(
                'splash' => array(
                    'border' => intval($_POST['splash_border']) < 0 || intval($_POST['splash_border']) > 7 ? 0 : intval($_POST['splash_border']),
                ),
                'main' => array(
                    'border' => intval($_POST['main_border']) < 0 || intval($_POST['main_border']) > 7 ? 0 : intval($_POST['main_border']),
                    'color' => $main_color < 0 || $main_color > 255 ? 0x47 : $main_color,
                ),
                'scroll' => array(
                    'direction' => 'left',
                    'coord_x' => 16,
                    'coord_y' => 4,
                    'visota' => 8
                ),
                '1' => false,
                '2' => false,
                '3' => false,
                '4' => false,
                // Добавляем данные musicbank ПОСЛЕ создания массива
                'musicbank' => $musicBankData,
            );

            // Load animations
            for ($i = 1; $i <= 4; $i++) {
                $result = $Zapilyator->upload('animation' . $i);
                if ($result == false) {
                    continue;
                }

                switch ($result['fileExtension']) {
                    case 'gif':
                        $source_type = 'gif';
                        break;
                    case 'zip':
                        $source_type = 'scr_zip';
                        break;
                    default:
                        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => 'Unknown animation type.'));
                        exit();
                }

                $speed = intval($_POST['speed' . $i]);
                $method = isset($_POST['animation' . $i . '_method']) ? $_POST['animation' . $i . '_method'] : 'memsave';
                if ($method !== 'fast' && $method !== 'memsave') {
                    $method = 'memsave';
                }

                $data[$i] = array(
                    'source' => $result['targetFile'],
                    'source_type' => $source_type,
                    'parsed' => array(),
                    'speed' => $speed >= 0 && $speed < 256 ? $speed : 0,
                    'totalFramesLen' => 0,
                    'totalBytesAff' => 0,
                    'is_done' => false,
                    'method' => $method
                );
            }

            // Splash screen
            $result = $Zapilyator->upload('splash_background');
            if ($result !== false) {
                $data['splash']['background'] = $result['targetFile'];
                $data['splash']['delay'] = intval($_POST['splash_delay']) < 1 || intval($_POST['splash_delay']) > 5 ? 1 : intval($_POST['splash_delay']);
            }

            // Main background
            $result = $Zapilyator->upload('main_background');
            if ($result !== false) {
                $data['main']['background'] = $result['targetFile'];
            }

            // Analyzer in main
            $main_analyzer_enabled = isset($_POST['main_analyzer_enabled']) ? intval($_POST['main_analyzer_enabled']) : 0;
            if ($main_analyzer_enabled) {
                $data['main']['analyzer']['enabled'] = true;
                $data['main']['analyzer']['type'] = isset($_POST['main_analyzer_type']) ? $_POST['main_analyzer_type'] : 'goba_left';
                
                // Добавляем поддержку координат x, y для goba анализаторов
                $data['main']['analyzer']['x'] = isset($_POST['main_analyzer_x']) ? intval($_POST['main_analyzer_x']) : 1;
                $data['main']['analyzer']['y'] = isset($_POST['main_analyzer_y']) ? intval($_POST['main_analyzer_y']) : 1;
                
                // Ограничиваем значения
                $data['main']['analyzer']['x'] = max(1, min(32, $data['main']['analyzer']['x']));
                $data['main']['analyzer']['y'] = max(1, min(24, $data['main']['analyzer']['y']));
            }

            // Scroll
            if (isset($_POST['scroll_text']) && $_POST['scroll_text']) {
                $data['scroll']['text'] = $_POST['scroll_text'];
                $data['scroll']['type'] = intval($_POST['scroll_type']) == 8 ? 8 : 16;
                $scroll_type = intval($_POST['scroll_type']) == 8 ? 8 : 16;
                $scroll_font = $_POST['scroll_font'];
                $data['scroll']['direction'] = isset($_POST['scroll_direction']) ? $_POST['scroll_direction'] : 'left';
                
                // Параметры координат для скролла up (сохраняем всегда)
                $data['scroll']['coord_x'] = isset($_POST['scroll_coord_x']) ? max(0, min(31, intval($_POST['scroll_coord_x']))) : 16;
                $data['scroll']['coord_y'] = isset($_POST['scroll_coord_y']) ? max(0, min(22, intval($_POST['scroll_coord_y']))) : 4;
                $data['scroll']['visota'] = isset($_POST['scroll_visota']) ? max(1, min(24, intval($_POST['scroll_visota']))) : 8;
                
                // Обработка шрифта в зависимости от типа
                if ($scroll_type == 8) {
                    if ($scroll_font == 'custom') {
                        // Пользовательский шрифт 8x8
                        $custom_font_result = $Zapilyator->upload('custom_font_file');
                        $custom_preview_result = $Zapilyator->upload('custom_font_preview');
                        if ($custom_font_result !== false) {
                            $data['scroll']['font'] = 'custom_8x8font';
                            $data['scroll']['custom_font_file'] = $custom_font_result['targetFile'];
                            if ($custom_preview_result !== false) {
                                $data['scroll']['custom_font_preview'] = $custom_preview_result['targetFile'];
                            }
                        } else {
                            // Если загрузка не удалась, используем стандартный
                            $data['scroll']['font'] = '8x8font';
                        }
                    } else {
                        $data['scroll']['font'] = '8x8font';
                    }
                } else {
                    if ($scroll_font == 'custom') {
                        // Пользовательский шрифт 16x16
                        $custom_font_result = $Zapilyator->upload('custom_font_file');
                        $custom_preview_result = $Zapilyator->upload('custom_font_preview');
                        if ($custom_font_result !== false) {
                            $data['scroll']['font'] = 'custom_16x16font';
                            $data['scroll']['custom_font_file'] = $custom_font_result['targetFile'];
                            if ($custom_preview_result !== false) {
                                $data['scroll']['custom_font_preview'] = $custom_preview_result['targetFile'];
                            }
                        } else {
                            // Если загрузка не удалась, используем стандартный
                            $data['scroll']['font'] = '16x16font1';
                        }
                    } else {
                        // Стандартные шрифты 16x16
                        $scroll_font_int = intval($scroll_font);
                        $data['scroll']['font'] = $scroll_font_int < 1 || $scroll_font_int > 3 ? '16x16font1' : '16x16font' . $scroll_font_int;
                    }
                }
                
                list($base_address, $base_attr) = explode('|', $_POST['scroll_position']);
                $scroll_width = intval($_POST['scroll_width']);
                $scroll_offset = intval($_POST['scroll_offset']);
                if ($scroll_width < 1) $scroll_width = 1;
                if ($scroll_width > 32) $scroll_width = 32;
                if ($scroll_offset < 0) $scroll_offset = 0;
                if ($scroll_offset > 31) $scroll_offset = 31;
                if ($scroll_width + $scroll_offset > 32) {
                    $scroll_offset = 32 - $scroll_width;
                }
                $base_addr_num = hexdec($base_address);
                $final_addr = '#' . sprintf('%04x', $base_addr_num - 32 + $scroll_width + $scroll_offset);
                $data['scroll']['address'] = $final_addr;
                $data['scroll']['attr'] = $base_attr;
                $data['scroll']['width'] = $scroll_width;
                $data['scroll']['offset'] = $scroll_offset;

                $scroll_color = intval($_POST['scroll_ink'] + $_POST['scroll_paper'] * 8 + $_POST['scroll_bright'] * 64);
                $data['scroll']['color'] = $scroll_color < 0 || $scroll_color > 255 ? 0x47 : $scroll_color;
            }

            // musicbank данные уже добавлены выше
            
            // Инициализируем анимации для musicbank
            for ($i = 1; $i <= 4; $i++) {
                $result = $Zapilyator->upload('animation' . $i);
                if ($result == false) {
                    continue;
                }

                switch ($result['fileExtension']) {
                    case 'gif':
                        $source_type = 'gif';
                        break;
                    case 'zip':
                        $source_type = 'scr_zip';
                        break;
                    default:
                        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => 'Unknown animation type.'));
                        exit();
                }

                $speed = intval($_POST['speed' . $i]);
                $method = isset($_POST['animation' . $i . '_method']) ? $_POST['animation' . $i . '_method'] : 'memsave';
                if ($method !== 'fast' && $method !== 'memsave') {
                    $method = 'memsave';
                }

                $data[$i] = array(
                    'source' => $result['targetFile'],
                    'source_type' => $source_type,
                    'parsed' => array(),
                    'speed' => $speed >= 0 && $speed < 256 ? $speed : 0,
                    'totalFramesLen' => 0,
                    'totalBytesAff' => 0,
                    'is_done' => false,
                    'method' => $method
                );
            }
            
            // Сохраняем проект
            $projectName = md5(NFW::i()->serializeArray($data));
            $Zapilyator->saveProject($projectName, $data);
            
            // Возвращаем для поэтапного парсинга анимаций
            NFW::i()->renderJSON(array(
                'result' => 'success',
                'stage' => 'parse_animation',
                'project_name' => $projectName,
                'trd_merge_enabled' => isset($_POST['trd_merge_enabled']) ? $_POST['trd_merge_enabled'] : '0',
                'int_counter_enabled' => isset($_POST['int_counter_enabled']) ? $_POST['int_counter_enabled'] : '0',
                'log' => array(
                    'MusicBank parsed and saved!',
                    'Starting animation parsing...',
                    '---'
                )
            ));
            exit();
                                    $resultZip = $Zapilyator->generateSource($data, $projectName);
            require_once PROJECT_ROOT . 'include/helpers/code_compiler.php';
            $compileLog = array('Compiling sources...');
            
            // Конфигурация моноблока в TRD (опционально)
            $trdMergeConfig = null;
            if (isset($_POST['trd_merge_enabled']) && $_POST['trd_merge_enabled'] == '1') {
                $trdMergeConfig = [
                    [
                        'files' => [
                            ['name' => 'boot.B', 'start' => 0x5C00],
                            ['name' => 'splash.C', 'start' => 0x6000],
                            ['name' => '0.C', 'start' => 0x6000],
                            ['name' => '1.C', 'start' => 0xC000],
                            ['name' => '3.C', 'start' => 0xC000],
                            ['name' => '4.C', 'start' => 0xC000],
                            ['name' => '6.C', 'start' => 0xC000],
                            ['name' => '7.C', 'start' => 0xC000]
                        ],
                        'output' => 'boot.B',
                        'address' => 0x5C00,
                        'remove_original' => true
                    ]
                ];
            }
            
            $result = CompileCode(CACHE_DIR, $projectName.'-out', CACHE_DIR . $resultZip, $trdMergeConfig);
            if ($result === false || !is_array($result)) {
                $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
            } else {
                if (!empty($result['log'])) {
                    $compileLog[] = '<pre style="max-height:300px;overflow:auto;font-size:12px;">'.htmlspecialchars($result['log']).'</pre>';
                }
                if ($result['result']) {
                    $compileLog[] = '<div class="text-success">Code compilation success</div>';
                } else {
                    $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
                }
            }
            NFW::i()->renderJSON(array(
                'result' => 'done',
                'download' => '?get_file=' . $resultZip,
                'log' => array_merge(array(
                    'MusicBank parsed and saved!',
                    'Generating sources...',
                    $Zapilyator->isOverflow ? '' : (function() use ($result, $Zapilyator) {
                        $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
                        $total = $pageInfo['total'] ?? $Zapilyator->getFreeSpace();
                        return 'Free space: <strong>' . number_format($total / 1024, 2, '.', '') . '</strong> kb (<strong>' . number_format($total, 0, '.', ' ') . '</strong> bytes)' . $pageInfo['html'];
                                        })(),
                    $Zapilyator->isOverflow ? '<div class="text-danger">RAM limit exceeded!</div>' : '<div class="text-success">Success!</div>',
                    '---',
                ), $compileLog),
            ));
            exit();
        } else {
            NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
            exit();
        }
    } else {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
        exit();
    }
}

// First stage - load data
if (!isset($_POST['stage'])) {
    $main_color = intval($_POST['main_ink'] + $_POST['main_paper'] * 8 + $_POST['main_bright'] * 64);
    $data = array(
        'splash' => array(
            'border' => intval($_POST['splash_border']) < 0 || intval($_POST['splash_border']) > 7 ? 0 : intval($_POST['splash_border']),
        ),
        'main' => array(
            'border' => intval($_POST['main_border']) < 0 || intval($_POST['main_border']) > 7 ? 0 : intval($_POST['main_border']),
            'color' => $main_color < 0 || $main_color > 255 ? 0x47 : $main_color,
        ),
        'scroll' => array(
            'direction' => 'left',
            'coord_x' => 16,
            'coord_y' => 4,
            'visota' => 8
        ),
        'int_counter_enabled' => '0',
        '1' => false,
        '2' => false,
        '3' => false,
        '4' => false,
    );

    // Load animations
    for ($i = 1; $i <= 4; $i++) {
        $result = $Zapilyator->upload('animation' . $i);
        if ($result == false) {
            continue;
        }

        switch ($result['fileExtension']) {
            case 'gif':
                $source_type = 'gif';
                break;
            case 'zip':
                $source_type = 'scr_zip';
                break;
            default:
                NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => 'Unknown animation type.'));
                exit();
        }

        $speed = intval($_POST['speed' . $i]);
        $method = isset($_POST['animation' . $i . '_method']) ? $_POST['animation' . $i . '_method'] : 'memsave';
        if ($method !== 'fast' && $method !== 'memsave') {
            $method = 'memsave';
        }

        $data[$i] = array(
            'source' => $result['targetFile'],
            'source_type' => $source_type,
            'parsed' => array(),
            'speed' => $speed >= 0 && $speed < 256 ? $speed : 0,
            'totalFramesLen' => 0,
            'totalBytesAff' => 0,
            'is_done' => false,
            'method' => $method
        );
    }

    if (isset($_FILES['music_file'])) {
        $result = $Zapilyator->upload('music_file');
        if ($result !== false) {
            $data['music_file'] = $result['targetFile'];
        }
    }

    // Splash screen
    $result = $Zapilyator->upload('splash_background');
    if ($result !== false) {
        $data['splash']['background'] = $result['targetFile'];
        $data['splash']['delay'] = intval($_POST['splash_delay']) < 1 || intval($_POST['splash_delay']) > 5 ? 1 : intval($_POST['splash_delay']);
    }

    // Main background
    $result = $Zapilyator->upload('main_background');
    if ($result !== false) {
        $data['main']['background'] = $result['targetFile'];
    }

    // Analyzer in main
    $main_analyzer_enabled = isset($_POST['main_analyzer_enabled']) ? intval($_POST['main_analyzer_enabled']) : 0;
    if ($main_analyzer_enabled) {
        $data['main']['analyzer']['enabled'] = true;
        $data['main']['analyzer']['type'] = isset($_POST['main_analyzer_type']) ? $_POST['main_analyzer_type'] : 'goba_left';
        
        // Добавляем поддержку координат x, y для goba анализаторов
        $data['main']['analyzer']['x'] = isset($_POST['main_analyzer_x']) ? intval($_POST['main_analyzer_x']) : 1;
        $data['main']['analyzer']['y'] = isset($_POST['main_analyzer_y']) ? intval($_POST['main_analyzer_y']) : 1;
        
        // Ограничиваем значения
        $data['main']['analyzer']['x'] = max(1, min(32, $data['main']['analyzer']['x']));
        $data['main']['analyzer']['y'] = max(1, min(24, $data['main']['analyzer']['y']));

    }



    // Scroll
    if ($_POST['scroll_text']) {
        $data['scroll']['text'] = $_POST['scroll_text'];
        $data['scroll']['type'] = intval($_POST['scroll_type']) == 8 ? 8 : 16;
        $scroll_type = intval($_POST['scroll_type']) == 8 ? 8 : 16;
        $scroll_font = $_POST['scroll_font'];
        $data['scroll']['direction'] = isset($_POST['scroll_direction']) ? $_POST['scroll_direction'] : 'left';
        
        // Параметры координат для скролла up (сохраняем всегда)
        $data['scroll']['coord_x'] = isset($_POST['scroll_coord_x']) ? max(0, min(31, intval($_POST['scroll_coord_x']))) : 16;
        $data['scroll']['coord_y'] = isset($_POST['scroll_coord_y']) ? max(0, min(22, intval($_POST['scroll_coord_y']))) : 4;
        $data['scroll']['visota'] = isset($_POST['scroll_visota']) ? max(1, min(24, intval($_POST['scroll_visota']))) : 8;
        
        // Обработка шрифта в зависимости от типа
        if ($scroll_type == 8) {
            if ($scroll_font == 'custom') {
                // Пользовательский шрифт 8x8
                $custom_font_result = $Zapilyator->upload('custom_font_file');
                $custom_preview_result = $Zapilyator->upload('custom_font_preview');
                if ($custom_font_result !== false) {
                    $data['scroll']['font'] = 'custom_8x8font';
                    $data['scroll']['custom_font_file'] = $custom_font_result['targetFile'];
                    if ($custom_preview_result !== false) {
                        $data['scroll']['custom_font_preview'] = $custom_preview_result['targetFile'];
                    }
                } else {
                    // Если загрузка не удалась, используем стандартный
                    $data['scroll']['font'] = '8x8font';
                }
            } else {
                // Стандартный шрифт 8x8
                $data['scroll']['font'] = '8x8font';
            }
        } else {
            // Для 16px типа используем шрифты 16x16
            if ($scroll_font == 'custom') {
                // Пользовательский шрифт 16x16
                $custom_font_result = $Zapilyator->upload('custom_font_file');
                $custom_preview_result = $Zapilyator->upload('custom_font_preview');
                if ($custom_font_result !== false) {
                    $data['scroll']['font'] = 'custom_16x16font';
                    $data['scroll']['custom_font_file'] = $custom_font_result['targetFile'];
                    if ($custom_preview_result !== false) {
                        $data['scroll']['custom_font_preview'] = $custom_preview_result['targetFile'];
                    }
                } else {
                    // Если загрузка не удалась, используем стандартный
                    $data['scroll']['font'] = '16x16font1';
                }
            } else {
                // Стандартные шрифты 16x16
                $scroll_font_int = intval($scroll_font);
                $data['scroll']['font'] = $scroll_font_int < 1 || $scroll_font_int > 3 ? '16x16font1' : '16x16font' . $scroll_font_int;
            }
        }
        
        list($base_address, $base_attr) = explode('|', $_POST['scroll_position']);
        $scroll_width = intval($_POST['scroll_width']);
        $scroll_offset = intval($_POST['scroll_offset']);
        if ($scroll_width < 1) $scroll_width = 1;
        if ($scroll_width > 32) $scroll_width = 32;
        if ($scroll_offset < 0) $scroll_offset = 0;
        if ($scroll_offset > 31) $scroll_offset = 31;
        if ($scroll_width + $scroll_offset > 32) {
            $scroll_offset = 32 - $scroll_width;
        }
        $base_addr_num = hexdec($base_address);
        $final_addr = '#' . sprintf('%04x', $base_addr_num - 32 + $scroll_width + $scroll_offset);
        $data['scroll']['address'] = $final_addr;
        $data['scroll']['attr'] = $base_attr;
        $data['scroll']['width'] = $scroll_width;
        $data['scroll']['offset'] = $scroll_offset;

        $scroll_color = intval($_POST['scroll_ink'] + $_POST['scroll_paper'] * 8 + $_POST['scroll_bright'] * 64);
        $data['scroll']['color'] = $scroll_color < 0 || $scroll_color > 255 ? 0x47 : $scroll_color;
    }

    // Upload done!
    $data['int_counter_enabled'] = isset($_POST['int_counter_enabled']) ? $_POST['int_counter_enabled'] : '0';
    $projectName = md5(NFW::i()->serializeArray($data));
    if (!$Zapilyator->saveProject($projectName, $data)) {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
    }

    NFW::i()->renderJSON(array(
        'result' => 'success',
        'stage' => 'parse_animation',
        'project_name' => $projectName,
        'trd_merge_enabled' => isset($_POST['trd_merge_enabled']) ? $_POST['trd_merge_enabled'] : '0',
        'log' => array(
            'Done!',
            '---',
            'Parsing animation data...'
        )
    ));
}

if (isset($_POST['stage']) && $_POST['stage'] == 'slideshow_parsed') {
    
    $projectName = isset($_POST['project_name']) ? $_POST['project_name'] : false;
    if (!$data = $Zapilyator->loadProject($projectName)) {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
    }
    
    // Обновляем int_counter_enabled для существующих проектов
    if (isset($_POST['int_counter_enabled'])) {
        $data['int_counter_enabled'] = $_POST['int_counter_enabled'];
        $Zapilyator->saveProject($projectName, $data);
    }
    
    // Генерируем исходники и компилируем
    $resultZip = $Zapilyator->generateSource($data, $projectName);
    require_once PROJECT_ROOT . 'include/helpers/code_compiler.php';
    $compileLog = array('Compiling sources...');
    
    // Конфигурация моноблока в TRD (опционально)
    $trdMergeConfig = null;

    
    if (isset($_POST['trd_merge_enabled']) && $_POST['trd_merge_enabled'] == '1') {


        $trdMergeConfig = [
            [
                'files' => [
                    ['name' => 'boot.B', 'start' => 0x5C00],
                    ['name' => 'splash.C', 'start' => 0x6000],
                    ['name' => '0.C', 'start' => 0x6000],
                    ['name' => '1.C', 'start' => 0xC000],
                    ['name' => '3.C', 'start' => 0xC000],
                    ['name' => '4.C', 'start' => 0xC000],
                    ['name' => '6.C', 'start' => 0xC000],
                    ['name' => '7.C', 'start' => 0xC000]
                ],
                'output' => 'boot.B',
                'address' => 0x5C00,
                'remove_original' => true
            ]
        ];

    } else {

    }
    

    $result = CompileCode(CACHE_DIR, $projectName.'-out', CACHE_DIR . $resultZip, $trdMergeConfig);
    if ($result === false || !is_array($result)) {
        $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
    } else {
        if (!empty($result['log'])) {
            $compileLog[] = '<pre style="max-height:300px;overflow:auto;font-size:12px;">'.htmlspecialchars($result['log']).'</pre>';
        }
        if ($result['result']) {
            $compileLog[] = '<div class="text-success">Code compilation success</div>';
        } else {
            $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
        }
    }
    // Build pages free breakdown from compiler log
    $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
    $pagesFreeHtml = $pageInfo['html'];
    $totalFreeBytesFromCompiler = $pageInfo['total'];

    NFW::i()->renderJSON(array(
        'result' => 'done',
        'download' => '?get_file=' . $resultZip,
        'log' => array_merge(array(
            'Generating sources...',
            (function() use ($result, $Zapilyator) {
                $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
                $total = $pageInfo['total'] ?? $Zapilyator->getFreeSpace();
                return 'Free space: <strong>' . number_format($total / 1024, 2, '.', '') . '</strong> kb (<strong>' . number_format($total, 0, '.', ' ') . '</strong> bytes)' . $pageInfo['html'];
            })(),
            $Zapilyator->isOverflow ? '<div class="text-danger">RAM limit exceeded!</div>' : '<div class="text-success">Success!</div>',
            '---',
        ), $compileLog),
    ));
    exit();
}

if (isset($_POST['stage']) && $_POST['stage'] == 'musicbank_parsed') {
    // Загружаем все данные из проекта
    $projectName = isset($_POST['project_name']) ? $_POST['project_name'] : false;
    if (!$data = $Zapilyator->loadProject($projectName)) {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
    }
    
    // Обновляем int_counter_enabled для существующих проектов
    if (isset($_POST['int_counter_enabled'])) {
        $data['int_counter_enabled'] = $_POST['int_counter_enabled'];
        $Zapilyator->saveProject($projectName, $data);
    }
    
    // Обрабатываем musicbank данные
    if (isset($_FILES['musicbank_zip'])) {
        $result = $Zapilyator->upload('musicbank_zip');
        if ($result !== false) {
            $musicBankData = $Zapilyator->parseMusicBank($result['targetFile']);
            if ($musicBankData !== false) {
                $data['musicbank'] = $musicBankData;
            }
        }
    }
    
    // Добавляем только эффекты из формы (анализатор, скроллер)
    
    // Analyzer in main
    $main_analyzer_enabled = isset($_POST['main_analyzer_enabled']) ? intval($_POST['main_analyzer_enabled']) : 0;
    if ($main_analyzer_enabled) {
        $data['main']['analyzer']['enabled'] = true;
        $data['main']['analyzer']['type'] = isset($_POST['main_analyzer_type']) ? $_POST['main_analyzer_type'] : 'goba_left';
        
        // Добавляем поддержку координат x, y для goba анализаторов
        $data['main']['analyzer']['x'] = isset($_POST['main_analyzer_x']) ? intval($_POST['main_analyzer_x']) : 1;
        $data['main']['analyzer']['y'] = isset($_POST['main_analyzer_y']) ? intval($_POST['main_analyzer_y']) : 1;
        
        // Ограничиваем значения
        $data['main']['analyzer']['x'] = max(1, min(32, $data['main']['analyzer']['x']));
        $data['main']['analyzer']['y'] = max(1, min(24, $data['main']['analyzer']['y']));
    }
    
    if (isset($data['musicbank'])) {
                }
            
            // Генерируем исходники и компилируем
            $resultZip = $Zapilyator->generateSource($data, $projectName);
            require_once PROJECT_ROOT . 'include/helpers/code_compiler.php';
            $compileLog = array('Compiling sources...');
            
            // Конфигурация моноблока в TRD (опционально)
            $trdMergeConfig = null;
            if (isset($_POST['trd_merge_enabled']) && $_POST['trd_merge_enabled'] == '1') {
                $trdMergeConfig = [
                    [
                        'files' => [
                            ['name' => 'boot.B', 'start' => 0x5C00],
                            ['name' => 'splash.C', 'start' => 0x6000],
                            ['name' => '0.C', 'start' => 0x6000],
                            ['name' => '1.C', 'start' => 0xC000],
                            ['name' => '3.C', 'start' => 0xC000],
                            ['name' => '4.C', 'start' => 0xC000],
                            ['name' => '6.C', 'start' => 0xC000],
                            ['name' => '7.C', 'start' => 0xC000]
                        ],
                        'output' => 'boot.B',
                        'address' => 0x5C00,
                        'remove_original' => true
                    ]
                ];
            }
            
            $result = CompileCode(CACHE_DIR, $projectName.'-out', CACHE_DIR . $resultZip, $trdMergeConfig);
    if ($result === false || !is_array($result)) {
        $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
    } else {
        if (!empty($result['log'])) {
            $compileLog[] = '<pre style="max-height:300px;overflow:auto;font-size:12px;">'.htmlspecialchars($result['log']).'</pre>';
        }
        if ($result['result']) {
            $compileLog[] = '<div class="text-success">Code compilation success</div>';
        } else {
            $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
        }
    }
    // Build pages free breakdown from compiler log
    $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
    $pagesFreeHtml = $pageInfo['html'];
    $totalFreeBytesFromCompiler = $pageInfo['total'];

    NFW::i()->renderJSON(array(
        'result' => 'done',
        'download' => '?get_file=' . $resultZip,
        'log' => array_merge(array(
            'Generating sources...',
            (function() use ($result, $Zapilyator) {
                $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
                $total = $pageInfo['total'] ?? $Zapilyator->getFreeSpace();
                return 'Free space: <strong>' . number_format($total / 1024, 2, '.', '') . '</strong> kb (<strong>' . number_format($total, 0, '.', ' ') . '</strong> bytes)' . $pageInfo['html'];
            })(),
            $Zapilyator->isOverflow ? '<div class="text-danger">RAM limit exceeded!</div>' : '<div class="text-success">Success!</div>',
            '---',
        ), $compileLog),
    ));
    exit();
}

if ($_POST['stage'] == 'parse_animation') {
    // Устанавливаем таймаут для всего этапа парсинга анимации
    set_time_limit(60); // 60 секунд максимум
    
    $projectName = isset($_POST['project_name']) ? $_POST['project_name'] : false;
    if (!$data = $Zapilyator->loadProject($_POST['project_name'])) {
        NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
    }
    
    // Обновляем int_counter_enabled для существующих проектов
    if (isset($_POST['int_counter_enabled'])) {
        $data['int_counter_enabled'] = $_POST['int_counter_enabled'];
        $Zapilyator->saveProject($projectName, $data);
    }
    
    // Устанавливаем значения по умолчанию для новых полей анализаторов
    if (isset($data['main']['analyzer']) && !isset($data['main']['analyzer']['type'])) {
        $data['main']['analyzer']['type'] = 'bright';
    }
    if (isset($data['splash']['analyzer']) && !isset($data['splash']['analyzer']['type'])) {
        $data['splash']['analyzer']['type'] = 'bright';
    }

    for ($i = 1; $i <= 4; $i++) {
        if (!$data[$i] || $data[$i]['is_done']) {
    
            continue;
        }
        

        
        $method = 'fast';
        if (isset($data[$i]['method'])) {
            if ($data[$i]['method'] == 'memsave') $method = ZXAnimation::METHOD_MEMSAVE;
            else $method = ZXAnimation::METHOD_FAST;
        }
        $data[$i]['position'] = $i == 1 ? 'main_flow' : 'timeline';

        $parseResult = $Zapilyator->parseAnimation($data, $i, $method);
        if ($parseResult === false) {
            // Ошибка парсинга анимации
            NFW::i()->renderJSON(array(
                'result' => 'error', 
                'last_msg' => 'Failed to parse animation ' . $i . '. Check error logs.'
            ));
            return;
        }
        
        list($data, $loading_result) = $parseResult;
        if ($loading_result['is_done']) {
            // Next animation
            $data['from'] = 0;
            $data[$i]['is_done'] = true;
            if (!$Zapilyator->saveProject($projectName, $data)) {
                NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
            }

            $log = array(
                'Parsed: <strong>' . $loading_result['from'] . ' - ' . $loading_result['to'] . '</strong> (' . $loading_result['total'] . ' total).',
                'Done!',
                'Animation size: <strong>' . number_format($data[$i]['totalFramesLen'], 0, '.', ' ') . '</strong> bytes',
                'Bytes affected: <strong>' . number_format($data[$i]['totalBytesAff'], 0, '.', ' ') . '</strong> bytes',
                'Data ratio: <strong>' . number_format($data[$i]['totalFramesLen'] / $data[$i]['totalBytesAff'], 2, '.', '') . '</strong> bytes',
                '---'
            );
            if ($i < 4) {
                $log[] = 'Parsing animation ' . ($i + 1) . '...';
            }

            NFW::i()->renderJSON(array(
                'result' => 'success',
                'stage' => 'parse_animation',
                'project_name' => $projectName,
                'trd_merge_enabled' => isset($_POST['trd_merge_enabled']) ? $_POST['trd_merge_enabled'] : '0',
                'int_counter_enabled' => isset($_POST['int_counter_enabled']) ? $_POST['int_counter_enabled'] : '0',
                'log' => $log
            ));
        } else {
            $data['from'] = $loading_result['to'] + 1;
            if (!$Zapilyator->saveProject($projectName, $data)) {
                NFW::i()->renderJSON(array('result' => 'error', 'last_msg' => $Zapilyator->last_msg));
            }

            NFW::i()->renderJSON(array(
                'result' => 'success',
                'stage' => 'parse_animation',
                'project_name' => $projectName,
                'trd_merge_enabled' => isset($_POST['trd_merge_enabled']) ? $_POST['trd_merge_enabled'] : '0',
                'int_counter_enabled' => isset($_POST['int_counter_enabled']) ? $_POST['int_counter_enabled'] : '0',
                'log' => array(
                    'Parsed: <strong>' . $loading_result['from'] . ' - ' . $loading_result['to'] . '</strong> (' . $loading_result['total'] . ' total).',
                )
            ));
        }
    }

    // Parsed successfully - make sources

    $resultZip = $Zapilyator->generateSource($data, $projectName);

    require_once PROJECT_ROOT . 'include/helpers/code_compiler.php';

    $compileLog = array(
        'Compiling sources...',
    );
    
    // Конфигурация моноблока в TRD (опционально)
    $trdMergeConfig = null;
    if (isset($_POST['trd_merge_enabled']) && $_POST['trd_merge_enabled'] == '1') {
        $trdMergeConfig = [
            [
                'files' => [
                    ['name' => 'boot.B', 'start' => 0x5C00],
                    ['name' => 'splash.C', 'start' => 0x6000],
                    ['name' => '0.C', 'start' => 0x6000],
                    ['name' => '1.C', 'start' => 0xC000],
                    ['name' => '3.C', 'start' => 0xC000],
                    ['name' => '4.C', 'start' => 0xC000],
                    ['name' => '6.C', 'start' => 0xC000],
                    ['name' => '7.C', 'start' => 0xC000]
                ],
                'output' => 'boot.B',
                'address' => 0x5C00,
                'remove_original' => true
            ]
        ];
    }

    $result = CompileCode(CACHE_DIR, $projectName.'-out', CACHE_DIR . $resultZip, $trdMergeConfig);
    if ($result === false || !is_array($result)) {
        $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
    } else {
        if (!empty($result['log'])) {
            $compileLog[] = '<pre style="max-height:300px;overflow:auto;font-size:12px;">'.htmlspecialchars($result['log']).'</pre>';
        }
        if ($result['result']) {
        $compileLog[] = '<div class="text-success">Code compilation success</div>';
        } else {
            $compileLog[] = '<div class="text-danger">Code compilation failed</div>';
        }
    }

    // Build pages free breakdown from compiler log
    $pageInfo = extractPageSizesFromLog(!empty($result['log']) ? $result['log'] : '');
    $pagesFreeHtml = $pageInfo['html'];
    $totalFreeBytesFromCompiler = $pageInfo['total'];

    NFW::i()->renderJSON(array(
        'result' => 'done',
        'download' => '?get_file=' . $resultZip,
        'log' => array_merge(array(
            'Generating sources...',
            $Zapilyator->isOverflow ? '' : 'Free space: <strong>' . number_format(($totalFreeBytesFromCompiler ?? $Zapilyator->getFreeSpace()) / 1024, 2, '.', '') . '</strong> kb (<strong>' . number_format($totalFreeBytesFromCompiler ?? $Zapilyator->getFreeSpace(), 0, '.', ' ') . '</strong> bytes)' . $pagesFreeHtml,
            $Zapilyator->isOverflow ? '<div class="text-danger">RAM limit exceeded!</div>' : '<div class="text-success">Success!</div>',
            '---',
        ), $compileLog),
    ));
}

NFW::i()->renderJSON(array('result' => 'error', 'errors' => array('Unknown error.')));