	define SNA_FILENAME "zapil.sna"
	define TRD_FILENAME "zapil.trd"

	device zxspectrum128

	%if_music%define _PLAY_MUSIC
	%if_play_musicbank%define _PLAY_MUSICBANK
	%if_animation_main_flow%define _ANIMATION_MAIN_FLOW
	%if_int_flow%define _INT_FLOW
	%if_scroll_up%define _SCROLL_UP
	%if_splash_bg%
	%if_int_counter%define int_counter

	page 0
		
	org #6000
page0s	di : ld sp, $-2

	ifdef _PLAY_MUSIC
	ld a, #10 : call setPage
	call PT3PLAY
	endif

	ifdef _PLAY_MUSICBANK
	call initmus
	ld a,#31
	ld (cifra+1),a
	endif
	
	ifdef _SCROLL_UP
	call init_up
	endif
	
	ld a,#5c, i,a, hl,interr, (#5cff),hl : im 2 : ei

	; main flow
%main_flow%

	ifdef _ANIMATION_MAIN_FLOW
cikla
	ifdef _PLAY_MUSICBANK
	ifdef int_counter
	ld a,1
	out (#fe),a
	endif
	call opros
	endif
	call ANIMATION1
	ifdef int_counter
	ld a,2
	out (#fe),a
	endif
	halt
	jr cikla
	else
	ifdef _PLAY_MUSICBANK
	call opros
	halt
	jr $-4
	else
	jr $
	endif
	endif
	ifdef _PLAY_MUSICBANK
opros:
	call #028e
	call #031e
	and a
	jr nz,cifra
	xor a
	ld (cifra+1),a
	ret
cifra:	
	ld b,0
	cp b
	ret z
	cp #30
	jr nz,dali
	ld a,(mus_kol+1)
	cp #3b
	jr nz,dali
	ld c,a
	ld a,#30
	ld (cifra+1),a
	ld a,c
	dec a
	jr dali2
dali:
	cp #31
	ret c
mus_kol
	cp #3b
	ret nc
	ld (cifra+1),a
dali2:
	sub #31
	add a,a
	add a,a
	ld e,a
	ld d,0
	ld hl,MusicBankTable
	add hl,de
	jr initmus+3
initmus:
	ld hl,MusicBankTable
	ld e,(hl)
	inc hl
	ld d,(hl)
	inc hl
	ld a,(hl)
	ld (mus_page+1),a
	ld bc,#7ffd
	out (c),a
	ex de,hl
	ifdef _PLAY_MUSICBANK
	push hl
	call restore
	pop hl
	endif
	jp PT3PLAY_MB+3
	endif

	;int flow
	ifdef _INT_FLOW
	; Обработчик перываний. Вызывается каждый int
intFlow
	ld hl, INT_DATA
ifMain	ld a, (hl) : inc hl
	cp #ff
	jp z,fixer	; end of flow
	or a : jr z, ifSkip7
	ld a, (hl) : inc hl : call setPage
	ld a, (hl) : inc hl : ld (ifCall + 1), a
	ld a, (hl) : inc hl : ld (ifCall + 2), a
	push hl 
ifCall	call #0000
	pop hl
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip3
	dec (hl) : ld a, (hl) : inc hl : cp #ff : jr nz, ifSkip2
	; закончили эффект
	ld de, #0006 : sbc hl, de
fix3:
	xor a
	ld (hl), a
	add hl, de
	inc hl
	ld a, (hl) : inc hl : cp #ff : jr z, ifMain ; после эффекта ничего
	push hl
fix1:
	call intFlowPush
	pop hl
	jr ifMain
ifSkip7	dup 4 : inc hl : edup
ifSkip3	inc hl	
ifSkip2	inc hl
ifSkip1	inc hl
	jr ifMain

	; Обработчик таймлайна. Вызывается после каждой смены паттерна
timelineUpdate
	; остановить процедуры, если stop_pattern == CUR_PATTERN
fix2:
	ld hl, CUR_PATTERN
	ld ix, INT_DATA
	ld de, #0008
tuStage1c	ld a, (ix + 0) : cp #ff : jr z, tuStage2
	or a : jr z, tuStage1e
	ld a, (ix + 6) : cp (hl) : jr nz, tuStage1e

	; останавливаем
	xor a : ld (ix + 0), a
tuStage1e	add ix, de
	jr tuStage1c

tuStage2	; сжать main cycle (выкинуть остановленные, остальное уплотнить)
	ld hl, INT_DATA + 8
	ld de, INT_DATA
	ld bc, #0008
tuStage2c	ld a, (hl) : cp #ff : jr z, tuStage3
	ld a, (de) : or a : jr nz, tuStage2sk
	ld a, (hl) : or a : jr z, tuStage2sk2
	; переносим
	push bc : ldir : pop bc	
	jr tuStage2c
tuStage2sk	ex de, hl : add hl, bc : ex de, hl 
tuStage2sk2	add hl, bc : jr tuStage2c

tuStage3	; добавить процедуры, если start_pattern == CUR_PATTERN
	ld ix, CUR_PATTERN
	ld hl, TIMELINE
	ld de, #0008
tuStage3c	ld a, (hl) : cp #ff : ret z
	cp (ix + 0) : jr nz, tuStage3e
	push hl, de
	call intFlowPushHL
	pop de, hl
tuStage3e	add hl, de : jr tuStage3c

	; Добавляем процедуру в обработчик перываний
	; a - номер процедуры в TIMELINE
intFlowPush
	ld h, #00 : ld l, a
	dup 3 : add hl, hl : edup
	ld de, TIMELINE
	add hl, de
intFlowPushHL
	ld de, INT_DATA
	ld bc, #0008
ifpCycle	ld a, (de) 
	or a : jr z, ifpDo
	cp #ff : jr z, ifpDo
	dup 8 : inc de : edup
	jr ifpCycle
ifpDo	; заносим
	push hl
	ld a, #01 : ld (hl), a ; маркер `run`
	ldir
	pop hl
	ld a, #fe : ld (hl), a ; защита от повторного добавления
	ret

INT_DATA	block 16*08, #ff
TIMELINE
%timeline%
	db #ff		; end of TIMELINE

%functions%	
	endif


CUR_PAGE	db #00
setPage
	or #10
	ld (CUR_PAGE), a : ld bc,#7ffd : out(c), a : ret

    ; Music and pattern handling
    ifdef _PLAY_MUSIC
CUR_PATTERN	db #ff
_curPattern	db #ff	
	align #100
PT3PLAY	include "sources/PTxPlay.asm"
	incbin "res/music"
	else
	; If only MusicBank is enabled, keep non-zero placeholder pattern
	ifdef _PLAY_MUSICBANK
CUR_PATTERN	db #ff
_curPattern	db #ff	
	else
	; No music at all: always 0 pattern
CUR_PATTERN	db #00
_curPattern	db #00
	endif
	endif

	; MusicBank player
	ifdef _PLAY_MUSICBANK
	align #100
PT3PLAY_MB	include "sources/PTxPlay.asm"
	endif

interr	di
	ld (stack+1),sp
	ld sp,#5fd0
	push af,bc,de,hl,ix,iy
	exx : ex af, af'
	push af,bc,de,hl,ix,iy
	
    ; save current page
	ifdef int_counter
	ld a,1
	out (#fe),a
	endif
	ld a, (CUR_PAGE)
	ld (_CP_REST + 1), a

	ifdef _INT_FLOW
	call intFlow
	endif

    ; Music tick and pattern update
    ifdef _PLAY_MUSICBANK
mus_page:
	ld a,#10
    ld bc,#7ffd
    out (c),a
	
	ifdef _PLAY_MUSICBANK
	call proverka
	endif
    
	call PT3PLAY_MB + 5
    ld a,#10
    ld bc,#7ffd
    out (c),a
	ld a, (PT3PLAY_MB  + 10)
	rla
	jr nc,play
	ld a,(mus_kol+1)
	ld   b,a
	ld   a,(cifra+1)
	cp   #30
	jr   nz,kotka
	add  a,#0A
kotka:
	inc  a
	cp   b
	jr   c,zapka
	ld   a,#31
zapka:
	ld   (cifra+1),a
	call dali2
    ; update timeline pattern from MusicBank player
play:
    ld a, (PT3PLAY_MB + 11)
    ld hl, _curPattern 
    cp (hl) : jr z, 1f
    ld (hl), a
    ld hl, CUR_PATTERN : inc (HL)
1 
    else
    ifdef _PLAY_MUSIC
    call PT3PLAY + 5
    ld a, (PT3PLAY + 11)
    ld hl, _curPattern 
    cp (hl) : jr z, 1f
    ld (hl), a
    ld hl, CUR_PATTERN : inc (HL)
1	
    endif
    endif

	ifdef _INT_FLOW
	call timelineUpdate
	endif

	; restore page
_CP_REST	ld a, #00 : call setPage
	ifdef int_counter
	ld a,2
	out (#fe),a
	endif
	pop iy,ix,hl,de,bc,af
	exx : ex af, af'
	pop iy,ix,hl,de,bc,af
stack:
	ld sp,0
	ei
	ret
	
	ifdef _INT_FLOW
fixer:
	ld a,(INT_DATA)
	cp #ff
	ret z
timer:
	ld a,0
	inc a
	ld (timer+1),a
	cp #ff
	ret nz
	ld a,#c9
	ld (fix2),a
	ld (timer-1),a
	xor a
	ld hl,0
	ld (fix1),a
	ld (fix1+1),hl
	ld (fix3),hl
	ret
	endif
	
	ifdef _PLAY_MUSICBANK
proverka:
	ld hl,(CrPsPtr)
	inc hl
	inc hl
	ld a,(hl)
	cp #ff
	ret nz
	
zatuh:
    ld   de,AYREGS+8
    ld   hl,zat+1
    ld   (hl),e
    inc  hl
    ld   (hl),d
    ld   hl,podmena
    ld   de,zamena
    ld   (hl),#CD
    inc  hl
    ld   (hl),e
    inc  hl
    ld   (hl),d
    ld   hl,pauza+1
    ld   (hl),#00
    inc  hl
    ld   (hl),#14
    ret
	
zamena:
    push hl
    ld   hl,pauza+2
pauza:
    ld   bc,#0000
    djnz zath1
    ld   b,#14
    inc  c
zath1:
    ld   (hl),b
    dec  hl
    ld   (hl),c
    ld   a,#10
    cp   c
    jr   nc,zath2
    ld   (hl),a
    ld   c,a
zath2:
    ld   b,#03
zat:
    ld   hl,0000
zath4:
    ld   a,(hl)
    and  #0F
    sub  c
    jr   nc,zath3
    xor  a
zath3:
    ld   (hl),a
    inc  hl
    djnz zath4
    xor  a
    ld   de,#FFBF
    pop  hl
    ret
restore:
    ld   hl,podmena
    ld   (hl),#11
    inc  hl
    ld   (hl),#BF
    inc  hl
    ld   (hl),#FF
    ret
	endif
	
%if_laser521%	include "sources/laser521.asm"

%data_flow%

; --- SlideShow integration ---
; SlideShowTable: dw offset, db bank ... dw $FFFF
; Используйте эту таблицу в своем Z80-коде для показа слайдов.

	include "sources/builder.asm"